USE [DBA_Reports]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[MonitoredServerList](
	[Server] [varchar](128) NOT NULL,
 CONSTRAINT [PK_MonitoredServerList] PRIMARY KEY CLUSTERED 
(
	[Server] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 80) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


USE [DBA_Reports]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[AuthorizedUsers](
	[ServerName] [nvarchar](128) NULL,
	[UserID] [sysname] NOT NULL,
	[Role] [varchar](13) NOT NULL,
	[AccountType] [nvarchar](60) NULL,
	[RunDate] [datetime] NOT NULL
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

USE [DBA_Reports]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[FailedLogins](
	[LogDate] [datetime] NOT NULL,
	[ProcessInfo] [varchar](50) NOT NULL,
	[Text] [varchar](max) NOT NULL,
	[ServerName] [varchar](50) NULL,
	[RunDate] [datetime] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


